/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k.indication.client;

import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCEvent;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSubscription;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSubscriptionMgr;
import java.io.Serializable;

public abstract class HSCCltSubscription
implements Serializable {
    public static final int SUB_SEND_REQUEST = -1;
    public static final int SUB_FAILED = 0;
    public static final int SUB_SUCCESS = 1;
    protected int mEvtType;
    protected String mObjType;
    protected int mSubId;
    protected String mUserName;
    protected String mPassword = null;
    protected boolean mSubscription;
    private String mAuthKey = null;

    public HSCCltSubscription(int n, String string, boolean bl, String string2, String string3) {
        this.mEvtType = n;
        this.mObjType = string;
        this.mSubscription = bl;
        this.mUserName = string2;
        if (string3 != null) {
            this.mPassword = this.passEncoding(string3);
        }
        this.mSubId = -1;
    }

    public String getAuthKey() {
        return this.mAuthKey;
    }

    public void setAuthKey(String string) {
        this.mAuthKey = string;
    }

    public abstract HSCCltSubscription copy();

    public abstract void handleEvent(HSCEvent var1, HSCSubscriptionMgr var2);

    public int getEventType() {
        return this.mEvtType;
    }

    public String getObjectType() {
        return this.mObjType;
    }

    public boolean isSubscription() {
        return this.mSubscription;
    }

    public void setSubscription(boolean bl) {
        this.mSubscription = bl;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String getPassword() {
        if (this.mPassword != null) {
            return this.passDecoding(this.mPassword);
        }
        return null;
    }

    public int getSubId() {
        return this.mSubId;
    }

    public void setSubId(int n) {
        this.mSubId = n;
    }

    private String passEncoding(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] + n * 2);
            ++n;
        }
        return new String(byArray);
    }

    private String passDecoding(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] - n * 2);
            ++n;
        }
        return new String(byArray);
    }

    public String getEventKey() {
        return HSCCltSubscription.getEventKey(this.mEvtType, this.mObjType);
    }

    public static String getEventKey(int n, String string) {
        return string + "-" + n;
    }

    public HSCSubscription getServerSub() {
        HSCSubscription hSCSubscription = new HSCSubscription(this.mEvtType, this.mObjType, this.mSubscription, null, null, null);
        hSCSubscription.setAuthKey(this.mAuthKey);
        return hSCSubscription;
    }
}

